<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\ProvinceServiceResource\Pages;
use App\Filament\Resources\ProvinceServiceResource\RelationManagers;
use App\Models\Locations\ProvinceService;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ProvinceServiceResource extends Resource
{
    protected static ?string $model = ProvinceService::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListProvinceServices::route('/'),
            'create' => Pages\CreateProvinceService::route('/create'),
            'edit' => Pages\EditProvinceService::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('province_id')->relationship('province', 'name')->required(),
            Forms\Components\TextInput::make('service_name'),
            Forms\Components\TextInput::make('service_description')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('province.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('service_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('service_description')->searchable()->sortable()->toggleable()
        ];
    }
}