<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\ProvinceItemResource\Pages;
use App\Filament\Resources\ProvinceItemResource\RelationManagers;
use App\Models\Items\ProvinceItem;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ProvinceItemResource extends Resource
{
    protected static ?string $model = ProvinceItem::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListProvinceItems::route('/'),
            'create' => Pages\CreateProvinceItem::route('/create'),
            'edit' => Pages\EditProvinceItem::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('item_id')->relationship('item', 'name')->required(),
            Forms\Components\Select::make('province_id')->relationship('province', 'name')->required()
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('item.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('province.name')->searchable()->sortable()->toggleable()
        ];
    }
}