<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\ProspectResource\Pages;
use App\Filament\Resources\ProspectResource\RelationManagers;
use App\Models\Contacts\Prospect;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ProspectResource extends Resource
{
    protected static ?string $model = Prospect::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListProspects::route('/'),
            'create' => Pages\CreateProspect::route('/create'),
            'edit' => Pages\EditProspect::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('user_id')->relationship('user', 'name')->required(),
            Forms\Components\Select::make('quote_id')->relationship('quote', 'name')->required(),
            Forms\Components\TextInput::make('prospects_first_name'),
            Forms\Components\TextInput::make('prospects_last_name'),
            Forms\Components\TextInput::make('prospects_business_name'),
            Forms\Components\Select::make('prospects_status')->options(\App\Enums\ProspectStatus::cases())->required(),
            Forms\Components\TextInput::make('prospects_number'),
            Forms\Components\TextInput::make('prospects_whatsapp'),
            Forms\Components\TextInput::make('prospects_email'),
            Forms\Components\TextInput::make('prospects_street_address'),
            Forms\Components\TextInput::make('prospects_suburb'),
            Forms\Components\TextInput::make('prospects_city'),
            Forms\Components\Select::make('prospects_province')->options(\App\Enums\ProvinceType::cases())->required()
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('user.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('quote.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('prospects_first_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('prospects_last_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('prospects_business_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('prospects_status')->formatStateUsing(fn($state) => \App\Enums\ProspectStatus::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('prospects_number')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('prospects_whatsapp')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('prospects_email')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('prospects_street_address')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('prospects_suburb')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('prospects_city')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('prospects_province')->formatStateUsing(fn($state) => \App\Enums\ProvinceType::tryFrom($state)?->label())->searchable()->sortable()->toggleable()
        ];
    }
}