<?php

namespace App\Filament\Resources\PaymentResource\RelationManagers;

use App\Filament\Resources\PaymentResource;


use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class PaymentMethodRelationManager extends RelationManager
{
    protected static string $relationship = 'paymentMethod';

    public function form(Form $form): Form
{
    return $form->schema(PaymentResource::getFormSchema());
}

    public function table(Table $table): Table
{
    return $table
        ->recordTitleAttribute('id')
        ->columns(PaymentResource::getTableSchema())
        ->filters([])
        ->headerActions([])
        ->actions([])
        ->bulkActions([]);
}
}
