<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\PaymentResource\Pages;
use App\Filament\Resources\PaymentResource\RelationManagers;
use App\Models\Finances\Payment;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class PaymentResource extends Resource
{
    protected static ?string $model = Payment::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPayments::route('/'),
            'create' => Pages\CreatePayment::route('/create'),
            'edit' => Pages\EditPayment::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('payment_method_id')->relationship('paymentMethod', 'name')->required(),
            Forms\Components\Select::make('payable_type')->options(\App\Enums\PaymentType::cases())->required(),
            Forms\Components\TextInput::make('payable_id'),
            Forms\Components\DatePicker::make('payment_date'),
            Forms\Components\TextInput::make('payment_amount')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('paymentMethod.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('payable_type')->formatStateUsing(fn($state) => \App\Enums\PaymentType::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('payable_id')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('payment_date')->date()->toggleable(),
            Tables\Columns\TextColumn::make('payment_amount')->searchable()->sortable()->toggleable()
        ];
    }
}