<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\OfficialableResource\Pages;
use App\Filament\Resources\OfficialableResource\RelationManagers;
use App\Models\Users\Officialable;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class OfficialableResource extends Resource
{
    protected static ?string $model = Officialable::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListOfficialables::route('/'),
            'create' => Pages\CreateOfficialable::route('/create'),
            'edit' => Pages\EditOfficialable::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('official_id')->relationship('official', 'name')->required(),
            Forms\Components\Select::make('officialable_type')->options(\App\Enums\OfficialType::cases())->required(),
            Forms\Components\Select::make('officialable_id')->relationship('officialable', 'name')->required()
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('official.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('officialable_type')->formatStateUsing(fn($state) => \App\Enums\OfficialType::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('officialable.name')->searchable()->sortable()->toggleable()
        ];
    }
}