<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\MunicipalityResource\Pages;
use App\Filament\Resources\MunicipalityResource\RelationManagers;
use App\Models\Locations\Municipality;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class MunicipalityResource extends Resource
{
    protected static ?string $model = Municipality::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListMunicipalities::route('/'),
            'create' => Pages\CreateMunicipality::route('/create'),
            'edit' => Pages\EditMunicipality::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('district_id')->relationship('district', 'name')->required(),
            Forms\Components\TextInput::make('municipality_name'),
            Forms\Components\TextInput::make('municipality_code'),
            Forms\Components\Select::make('municipality_type')->options(\App\Enums\MunicipalityType::cases())->required(),
            Forms\Components\Select::make('parent_id')->relationship('parent', 'name')->required()
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('district.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('municipality_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('municipality_code')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('municipality_type')->formatStateUsing(fn($state) => \App\Enums\MunicipalityType::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('parent.name')->searchable()->sortable()->toggleable()
        ];
    }
}