<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\LeaveRequestResource\Pages;
use App\Filament\Resources\LeaveRequestResource\RelationManagers;
use App\Models\Users\LeaveRequest;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class LeaveRequestResource extends Resource
{
    protected static ?string $model = LeaveRequest::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListLeaveRequests::route('/'),
            'create' => Pages\CreateLeaveRequest::route('/create'),
            'edit' => Pages\EditLeaveRequest::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('user_id')->relationship('user', 'name')->required(),
            Forms\Components\TextInput::make('approval_user_id'),
            Forms\Components\DatePicker::make('leave_date_from'),
            Forms\Components\DatePicker::make('leave_date_to'),
            Forms\Components\TextInput::make('leave_reason'),
            Forms\Components\Select::make('leave_status')->options(\App\Enums\LeaveRequestStatus::cases())->required(),
            Forms\Components\TextInput::make('leave_message')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('user.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('approval_user_id')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('leave_date_from')->date()->toggleable(),
            Tables\Columns\TextColumn::make('leave_date_to')->date()->toggleable(),
            Tables\Columns\TextColumn::make('leave_reason')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('leave_status')->formatStateUsing(fn($state) => \App\Enums\LeaveRequestStatus::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('leave_message')->searchable()->sortable()->toggleable()
        ];
    }
}