<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\LeadResource\Pages;
use App\Filament\Resources\LeadResource\RelationManagers;
use App\Models\Contacts\Lead;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class LeadResource extends Resource
{
    protected static ?string $model = Lead::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListLeads::route('/'),
            'create' => Pages\CreateLead::route('/create'),
            'edit' => Pages\EditLead::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('user_id')->relationship('user', 'name')->required(),
            Forms\Components\TextInput::make('lead_first_name'),
            Forms\Components\TextInput::make('lead_last_name'),
            Forms\Components\TextInput::make('lead_email'),
            Forms\Components\TextInput::make('lead_number'),
            Forms\Components\TextInput::make('lead_town_city'),
            Forms\Components\TextInput::make('lead_province'),
            Forms\Components\TextInput::make('lead_enquiries')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('user.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('lead_first_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('lead_last_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('lead_email')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('lead_number')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('lead_town_city')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('lead_province')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('lead_enquiries')->searchable()->sortable()->toggleable()
        ];
    }
}