<?php

namespace App\Filament\Resources\ItemResource\RelationManagers;

use App\Filament\Resources\ItemResource;


use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class CategoryRelationManager extends RelationManager
{
    protected static string $relationship = 'category';

    public function form(Form $form): Form
{
    return $form->schema(ItemResource::getFormSchema());
}

    public function table(Table $table): Table
{
    return $table
        ->recordTitleAttribute('id')
        ->columns(ItemResource::getTableSchema())
        ->filters([])
        ->headerActions([])
        ->actions([])
        ->bulkActions([]);
}
}
