<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\ItemResource\Pages;
use App\Filament\Resources\ItemResource\RelationManagers;
use App\Models\Items\Item;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ItemResource extends Resource
{
    protected static ?string $model = Item::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListItems::route('/'),
            'create' => Pages\CreateItem::route('/create'),
            'edit' => Pages\EditItem::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('category_id')->relationship('category', 'name')->required(),
            Forms\Components\Select::make('province_service_id')->relationship('provinceService', 'name')->required(),
            Forms\Components\TextInput::make('item_name'),
            Forms\Components\TextInput::make('item_description'),
            Forms\Components\TextInput::make('item_price')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('category.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('provinceService.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_description')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_price')->searchable()->sortable()->toggleable()
        ];
    }
}