<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\ItemExpenseResource\Pages;
use App\Filament\Resources\ItemExpenseResource\RelationManagers;
use App\Models\Items\ItemExpense;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ItemExpenseResource extends Resource
{
    protected static ?string $model = ItemExpense::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListItemExpenses::route('/'),
            'create' => Pages\CreateItemExpense::route('/create'),
            'edit' => Pages\EditItemExpense::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('item_id')->relationship('item', 'name')->required(),
            Forms\Components\TextInput::make('item_expense_name'),
            Forms\Components\TextInput::make('item_expense_description'),
            Forms\Components\TextInput::make('item_expense_price')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('item.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_expense_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_expense_description')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_expense_price')->searchable()->sortable()->toggleable()
        ];
    }
}