<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\InvoiceTermsResource\Pages;
use App\Filament\Resources\InvoiceTermsResource\RelationManagers;
use App\Models\Invoices\InvoiceTerms;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class InvoiceTermsResource extends Resource
{
    protected static ?string $model = InvoiceTerms::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListInvoiceTerms::route('/'),
            'create' => Pages\CreateInvoiceTerms::route('/create'),
            'edit' => Pages\EditInvoiceTerms::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\TextInput::make('invoice_terms_name'),
            Forms\Components\TextInput::make('invoice_terms_description'),
            Forms\Components\TextInput::make('invoice_terms_content')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('invoice_terms_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('invoice_terms_description')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('invoice_terms_content')->searchable()->sortable()->toggleable()
        ];
    }
}