<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\InvoiceResource\Pages;
use App\Filament\Resources\InvoiceResource\RelationManagers;
use App\Models\Invoices\Invoice;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class InvoiceResource extends Resource
{
    protected static ?string $model = Invoice::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListInvoices::route('/'),
            'create' => Pages\CreateInvoice::route('/create'),
            'edit' => Pages\EditInvoice::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('user_id')->relationship('user', 'name')->required(),
            Forms\Components\Select::make('business_id')->relationship('business', 'name')->required(),
            Forms\Components\Select::make('franchise_id')->relationship('franchise', 'name')->required(),
            Forms\Components\Select::make('quote_id')->relationship('quote', 'name')->required(),
            Forms\Components\TextInput::make('invoice_terms_id'),
            Forms\Components\TextInput::make('invoice_number'),
            Forms\Components\Select::make('invoice_status')->options(\App\Enums\InvoiceStatus::cases())->required(),
            Forms\Components\TextInput::make('invoice_url_key'),
            Forms\Components\Toggle::make('is_read_only'),
            Forms\Components\Toggle::make('invoice_is_altered'),
            Forms\Components\TextInput::make('invoice_item_discount_total'),
            Forms\Components\TextInput::make('invoice_item_tax_total'),
            Forms\Components\TextInput::make('invoice_item_subtotal'),
            Forms\Components\TextInput::make('invoice_balance'),
            Forms\Components\TextInput::make('invoice_paid'),
            Forms\Components\DatePicker::make('invoice_date_due')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('user.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('business.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('franchise.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('quote.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('invoice_terms_id')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('invoice_number')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('invoice_status')->formatStateUsing(fn($state) => \App\Enums\InvoiceStatus::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('invoice_url_key')->searchable()->sortable()->toggleable(),
            Tables\Columns\IconColumn::make('is_read_only')->boolean()->toggleable(),
            Tables\Columns\IconColumn::make('invoice_is_altered')->boolean()->toggleable(),
            Tables\Columns\TextColumn::make('invoice_item_discount_total')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('invoice_item_tax_total')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('invoice_item_subtotal')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('invoice_balance')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('invoice_paid')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('invoice_date_due')->date()->toggleable()
        ];
    }
}