<?php

namespace App\Filament\Resources\InvoiceItemExpenseResource\RelationManagers;

use App\Filament\Resources\InvoiceItemExpenseResource;


use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class InvoiceItemRelationManager extends RelationManager
{
    protected static string $relationship = 'invoiceItem';

    public function form(Form $form): Form
{
    return $form->schema(InvoiceItemExpenseResource::getFormSchema());
}

    public function table(Table $table): Table
{
    return $table
        ->recordTitleAttribute('id')
        ->columns(InvoiceItemExpenseResource::getTableSchema())
        ->filters([])
        ->headerActions([])
        ->actions([])
        ->bulkActions([]);
}
}
