<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\FranchiseResource\Pages;
use App\Filament\Resources\FranchiseResource\RelationManagers;
use App\Models\Locations\Franchise;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class FranchiseResource extends Resource
{
    protected static ?string $model = Franchise::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListFranchises::route('/'),
            'create' => Pages\CreateFranchise::route('/create'),
            'edit' => Pages\EditFranchise::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('province_id')->relationship('province', 'name')->required(),
            Forms\Components\Select::make('municipality_id')->relationship('municipality', 'name')->required(),
            Forms\Components\TextInput::make('franchise_name'),
            Forms\Components\TextInput::make('franchise_acronym'),
            Forms\Components\TextInput::make('settings_package'),
            Forms\Components\Toggle::make('setting_use_global'),
            Forms\Components\TextInput::make('next_id')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('province.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('municipality.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('franchise_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('franchise_acronym')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('settings_package')->searchable()->sortable()->toggleable(),
            Tables\Columns\IconColumn::make('setting_use_global')->boolean()->toggleable(),
            Tables\Columns\TextColumn::make('next_id')->searchable()->sortable()->toggleable()
        ];
    }
}