<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\ExpenseResource\Pages;
use App\Filament\Resources\ExpenseResource\RelationManagers;
use App\Models\Finances\Expense;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ExpenseResource extends Resource
{
    protected static ?string $model = Expense::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListExpenses::route('/'),
            'create' => Pages\CreateExpense::route('/create'),
            'edit' => Pages\EditExpense::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('creditor_id')->relationship('creditor', 'name')->required(),
            Forms\Components\Select::make('expense_category_id')->relationship('expenseCategory', 'name')->required(),
            Forms\Components\TextInput::make('expense_description'),
            Forms\Components\TextInput::make('expense_total'),
            Forms\Components\DatePicker::make('expense_date'),
            Forms\Components\TextInput::make('expense_paid'),
            Forms\Components\Select::make('expense_type')->options(\App\Enums\ExpenseType::cases())->required(),
            Forms\Components\Select::make('expense_status')->options(\App\Enums\ExpenseStatus::cases())->required()
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('creditor.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('expenseCategory.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('expense_description')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('expense_total')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('expense_date')->date()->toggleable(),
            Tables\Columns\TextColumn::make('expense_paid')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('expense_type')->formatStateUsing(fn($state) => \App\Enums\ExpenseType::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('expense_status')->formatStateUsing(fn($state) => \App\Enums\ExpenseStatus::tryFrom($state)?->label())->searchable()->sortable()->toggleable()
        ];
    }
}