<?php

namespace App\Filament\Resources\ExpenseCategoryResource\RelationManagers;

use App\Filament\Resources\ExpenseCategoryResource;


use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ExpenseBankCategoryRelationManager extends RelationManager
{
    protected static string $relationship = 'expenseBankCategory';

    public function form(Form $form): Form
{
    return $form->schema(ExpenseCategoryResource::getFormSchema());
}

    public function table(Table $table): Table
{
    return $table
        ->recordTitleAttribute('id')
        ->columns(ExpenseCategoryResource::getTableSchema())
        ->filters([])
        ->headerActions([])
        ->actions([])
        ->bulkActions([]);
}
}
