<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\EmailTemplateResource\Pages;
use App\Filament\Resources\EmailTemplateResource\RelationManagers;
use App\Models\Users\EmailTemplate;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class EmailTemplateResource extends Resource
{
    protected static ?string $model = EmailTemplate::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListEmailTemplates::route('/'),
            'create' => Pages\CreateEmailTemplate::route('/create'),
            'edit' => Pages\EditEmailTemplate::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\TextInput::make('email_template_title'),
            Forms\Components\Select::make('email_template_type')->options(\App\Enums\EmailTemplateType::cases())->required(),
            Forms\Components\TextInput::make('email_template_body'),
            Forms\Components\TextInput::make('email_template_subject'),
            Forms\Components\TextInput::make('email_template_from_name'),
            Forms\Components\TextInput::make('email_template_from_email'),
            Forms\Components\TextInput::make('email_template_cc'),
            Forms\Components\TextInput::make('email_template_bcc')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('email_template_title')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('email_template_type')->formatStateUsing(fn($state) => \App\Enums\EmailTemplateType::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('email_template_body')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('email_template_subject')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('email_template_from_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('email_template_from_email')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('email_template_cc')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('email_template_bcc')->searchable()->sortable()->toggleable()
        ];
    }
}