<?php

namespace App\Filament\Resources\DistrictResource\RelationManagers;

use App\Filament\Resources\DistrictResource;


use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ProvinceRelationManager extends RelationManager
{
    protected static string $relationship = 'province';

    public function form(Form $form): Form
{
    return $form->schema(DistrictResource::getFormSchema());
}

    public function table(Table $table): Table
{
    return $table
        ->recordTitleAttribute('id')
        ->columns(DistrictResource::getTableSchema())
        ->filters([])
        ->headerActions([])
        ->actions([])
        ->bulkActions([]);
}
}
