<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\DisciplinaryResource\Pages;
use App\Filament\Resources\DisciplinaryResource\RelationManagers;
use App\Models\Users\Disciplinary;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class DisciplinaryResource extends Resource
{
    protected static ?string $model = Disciplinary::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListDisciplinaries::route('/'),
            'create' => Pages\CreateDisciplinary::route('/create'),
            'edit' => Pages\EditDisciplinary::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\TextInput::make('disciplinary_type'),
            Forms\Components\TextInput::make('disciplinaries_reason')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('disciplinary_type')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('disciplinaries_reason')->searchable()->sortable()->toggleable()
        ];
    }
}