<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\ContactResource\Pages;
use App\Filament\Resources\ContactResource\RelationManagers;
use App\Models\Contacts\Contact;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ContactResource extends Resource
{
    protected static ?string $model = Contact::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListContacts::route('/'),
            'create' => Pages\CreateContact::route('/create'),
            'edit' => Pages\EditContact::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\TextInput::make('contact_first_name'),
            Forms\Components\TextInput::make('contact_last_name'),
            Forms\Components\TextInput::make('contact_id_number'),
            Forms\Components\TextInput::make('contact_passport_number'),
            Forms\Components\Select::make('contact_gender')->options(\App\Enums\GenderType::cases())->required()
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('contact_first_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('contact_last_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('contact_id_number')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('contact_passport_number')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('contact_gender')->formatStateUsing(fn($state) => \App\Enums\GenderType::tryFrom($state)?->label())->searchable()->sortable()->toggleable()
        ];
    }
}