<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\ContactMethodResource\Pages;
use App\Filament\Resources\ContactMethodResource\RelationManagers;
use App\Models\Contacts\ContactMethod;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ContactMethodResource extends Resource
{
    protected static ?string $model = ContactMethod::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListContactMethods::route('/'),
            'create' => Pages\CreateContactMethod::route('/create'),
            'edit' => Pages\EditContactMethod::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('contact_id')->relationship('contact', 'name')->required(),
            Forms\Components\Select::make('contact_method_type')->options(\App\Enums\ContactMethodType::cases())->required(),
            Forms\Components\TextInput::make('contact_method_info'),
            Forms\Components\Toggle::make('is_primary')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('contact.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('contact_method_type')->formatStateUsing(fn($state) => \App\Enums\ContactMethodType::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('contact_method_info')->searchable()->sortable()->toggleable(),
            Tables\Columns\IconColumn::make('is_primary')->boolean()->toggleable()
        ];
    }
}