<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\ChangeRequestResource\Pages;
use App\Filament\Resources\ChangeRequestResource\RelationManagers;
use App\Models\Users\ChangeRequest;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ChangeRequestResource extends Resource
{
    protected static ?string $model = ChangeRequest::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListChangeRequests::route('/'),
            'create' => Pages\CreateChangeRequest::route('/create'),
            'edit' => Pages\EditChangeRequest::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('user_id')->relationship('user', 'name')->required(),
            Forms\Components\Select::make('changable_type')->options(\App\Enums\ChangeRequestType::cases())->required(),
            Forms\Components\Select::make('changable_id')->relationship('changable', 'name')->required(),
            Forms\Components\TextInput::make('change_reason'),
            Forms\Components\Select::make('change_status')->options(\App\Enums\ChangeRequestStatus::cases())->required(),
            Forms\Components\TextInput::make('targetable_id'),
            Forms\Components\Select::make('targetable_type')->options(\App\Enums\ChangeRequestTargetType::cases())->required(),
            Forms\Components\Select::make('change_action')->options(\App\Enums\ChangeRequestAction::cases())->required()
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('user.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('changable_type')->formatStateUsing(fn($state) => \App\Enums\ChangeRequestType::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('changable.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('change_reason')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('change_status')->formatStateUsing(fn($state) => \App\Enums\ChangeRequestStatus::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('targetable_id')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('targetable_type')->formatStateUsing(fn($state) => \App\Enums\ChangeRequestTargetType::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('change_action')->formatStateUsing(fn($state) => \App\Enums\ChangeRequestAction::tryFrom($state)?->label())->searchable()->sortable()->toggleable()
        ];
    }
}