<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\BusinessResource\Pages;
use App\Filament\Resources\BusinessResource\RelationManagers;
use App\Models\Businesses\Business;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class BusinessResource extends Resource
{
    protected static ?string $model = Business::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBusinesses::route('/'),
            'create' => Pages\CreateBusiness::route('/create'),
            'edit' => Pages\EditBusiness::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('user_id')->relationship('user', 'name')->required(),
            Forms\Components\TextInput::make('business_reg_number'),
            Forms\Components\TextInput::make('business_reg_name'),
            Forms\Components\TextInput::make('business_trading_name'),
            Forms\Components\TextInput::make('business_VAT_number'),
            Forms\Components\Select::make('business_type')->options(\App\Enums\BusinessType::cases())->required(),
            Forms\Components\DatePicker::make('business_reg_date')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('user.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('business_reg_number')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('business_reg_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('business_trading_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('business_VAT_number')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('business_type')->formatStateUsing(fn($state) => \App\Enums\BusinessType::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('business_reg_date')->date()->toggleable()
        ];
    }
}