<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\BusinessItemResource\Pages;
use App\Filament\Resources\BusinessItemResource\RelationManagers;
use App\Models\Items\BusinessItem;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class BusinessItemResource extends Resource
{
    protected static ?string $model = BusinessItem::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBusinessItems::route('/'),
            'create' => Pages\CreateBusinessItem::route('/create'),
            'edit' => Pages\EditBusinessItem::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('business_id')->relationship('business', 'name')->required(),
            Forms\Components\Select::make('item_id')->relationship('item', 'name')->required(),
            Forms\Components\Select::make('invoice_id')->relationship('invoice', 'name')->required(),
            Forms\Components\Select::make('item_step_id')->relationship('itemStep', 'name')->required(),
            Forms\Components\DatePicker::make('approved_date'),
            Forms\Components\DatePicker::make('renew_date'),
            Forms\Components\DatePicker::make('expiry_date'),
            Forms\Components\Select::make('item_status')->options(\App\Enums\BusinessItemStatus::cases())->required(),
            Forms\Components\TextInput::make('item_name'),
            Forms\Components\TextInput::make('item_description'),
            Forms\Components\TextInput::make('item_price')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('business.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('invoice.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('itemStep.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('approved_date')->date()->toggleable(),
            Tables\Columns\TextColumn::make('renew_date')->date()->toggleable(),
            Tables\Columns\TextColumn::make('expiry_date')->date()->toggleable(),
            Tables\Columns\TextColumn::make('item_status')->formatStateUsing(fn($state) => \App\Enums\BusinessItemStatus::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_description')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('item_price')->searchable()->sortable()->toggleable()
        ];
    }
}