<?php

namespace App\Filament\Resources\BusinessItemExtraFieldResource\RelationManagers;

use App\Filament\Resources\BusinessItemExtraFieldResource;


use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class BusinessItemRelationManager extends RelationManager
{
    protected static string $relationship = 'businessItem';

    public function form(Form $form): Form
{
    return $form->schema(BusinessItemExtraFieldResource::getFormSchema());
}

    public function table(Table $table): Table
{
    return $table
        ->recordTitleAttribute('id')
        ->columns(BusinessItemExtraFieldResource::getTableSchema())
        ->filters([])
        ->headerActions([])
        ->actions([])
        ->bulkActions([]);
}
}
