<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\BusinessItemExtraFieldResource\Pages;
use App\Filament\Resources\BusinessItemExtraFieldResource\RelationManagers;
use App\Models\Items\BusinessItemExtraField;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class BusinessItemExtraFieldResource extends Resource
{
    protected static ?string $model = BusinessItemExtraField::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBusinessItemExtraFields::route('/'),
            'create' => Pages\CreateBusinessItemExtraField::route('/create'),
            'edit' => Pages\EditBusinessItemExtraField::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('business_item_id')->relationship('businessItem', 'name')->required(),
            Forms\Components\Select::make('extra_field_name')->options(\App\Enums\BusinessExtraItemFieldName::cases())->required(),
            Forms\Components\TextInput::make('extra_field_value')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('businessItem.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('extra_field_name')->formatStateUsing(fn($state) => \App\Enums\BusinessExtraItemFieldName::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('extra_field_value')->searchable()->sortable()->toggleable()
        ];
    }
}