<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\BusinessClientResource\Pages;
use App\Filament\Resources\BusinessClientResource\RelationManagers;
use App\Models\Businesses\BusinessClient;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class BusinessClientResource extends Resource
{
    protected static ?string $model = BusinessClient::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBusinessClients::route('/'),
            'create' => Pages\CreateBusinessClient::route('/create'),
            'edit' => Pages\EditBusinessClient::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('client_id')->relationship('client', 'name')->required(),
            Forms\Components\Select::make('business_id')->relationship('business', 'name')->required(),
            Forms\Components\Select::make('client_role')->options(\App\Enums\BusinessClientRole::cases())->required(),
            Forms\Components\Toggle::make('is_primary')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('client.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('business.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('client_role')->formatStateUsing(fn($state) => \App\Enums\BusinessClientRole::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\IconColumn::make('is_primary')->boolean()->toggleable()
        ];
    }
}