<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\AddressableResource\Pages;
use App\Filament\Resources\AddressableResource\RelationManagers;
use App\Models\Contacts\Addressable;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class AddressableResource extends Resource
{
    protected static ?string $model = Addressable::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAddressables::route('/'),
            'create' => Pages\CreateAddressable::route('/create'),
            'edit' => Pages\EditAddressable::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('address_id')->relationship('address', 'name')->required(),
            Forms\Components\Select::make('addressable_type')->options(\App\Enums\AddressableType::cases())->required(),
            Forms\Components\Select::make('addressable_id')->relationship('addressable', 'name')->required(),
            Forms\Components\Select::make('address_relationship')->options(\App\Enums\AddressRelationship::cases())->required()
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('address.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('addressable_type')->formatStateUsing(fn($state) => \App\Enums\AddressableType::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('addressable.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('address_relationship')->formatStateUsing(fn($state) => \App\Enums\AddressRelationship::tryFrom($state)?->label())->searchable()->sortable()->toggleable()
        ];
    }
}