<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\AddressResource\Pages;
use App\Filament\Resources\AddressResource\RelationManagers;
use App\Models\Contacts\Address;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Collection;

class AddressResource extends Resource
{
    protected static ?string $model = Address::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form->schema(self::getFormSchema());
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns(self::getTableSchema())
            ->filters([])
            ->actions([
                EditAction::make(),
            ])
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAddresses::route('/'),
            'create' => Pages\CreateAddress::route('/create'),
            'edit' => Pages\EditAddress::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\TextInput::make('street_address'),
            Forms\Components\TextInput::make('suburb'),
            Forms\Components\TextInput::make('city'),
            Forms\Components\Select::make('province')->options(
                Collection::make(\App\Enums\Locations\ProvinceType::cases())
                    ->mapWithKeys(fn(\App\Enums\Locations\ProvinceType $case) => [
                        $case->value => $case->label(),
                    ])
                    ->toArray()
            )->required(),
            Forms\Components\TextInput::make('postal_code')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('street_address')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('suburb')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('city')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('province')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('postal_code')->searchable()->sortable()->toggleable()
        ];
    }
}