<?php

namespace App\Filament\Resources;

use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;

use App\Filament\Resources\AddressExtraFieldResource\Pages;
use App\Filament\Resources\AddressExtraFieldResource\RelationManagers;
use App\Models\Contacts\AddressExtraField;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class AddressExtraFieldResource extends Resource
{
    protected static ?string $model = AddressExtraField::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
{
    return $form->schema(self::getFormSchema());
}

    public static function table(Table $table): Table
{
    return $table
        ->columns(self::getTableSchema())
        ->filters([])
        ->actions([
            EditAction::make(),
        ])
        ->bulkActions([
            BulkActionGroup::make([
                DeleteBulkAction::make(),
            ]),
        ]);
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAddressExtraFields::route('/'),
            'create' => Pages\CreateAddressExtraField::route('/create'),
            'edit' => Pages\EditAddressExtraField::route('/{record}/edit'),
        ];
    }

    public static function getFormSchema(): array
    {
        return [
            Forms\Components\Select::make('address_id')->relationship('address', 'name')->required(),
            Forms\Components\Select::make('address_field_name')->options(\App\Enums\AddressExtraFieldType::cases())->required(),
            Forms\Components\TextInput::make('address_field_value')
        ];
    }

    public static function getTableSchema(): array
    {
        return [
            Tables\Columns\TextColumn::make('address.name')->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('address_field_name')->formatStateUsing(fn($state) => \App\Enums\AddressExtraFieldType::tryFrom($state)?->label())->searchable()->sortable()->toggleable(),
            Tables\Columns\TextColumn::make('address_field_value')->searchable()->sortable()->toggleable()
        ];
    }
}